/**
 * Beschrijft het personage Indiaan van een computergame.
 * 
 * @author Dominiek Vandewalle
 * @version 2016-04-12
 */
public class Indiaan
{
    //velden
    private String naam;
    private int aantalLevens;
    private int gezondheid;
    

    /**
     * Constructor voor objecten van de klasse Indiaan.
     * @param   naam    De naam van de Indiaan.
     */
    public Indiaan(String naam)
    {
        this.naam = naam;
        aantalLevens = 5;
        gezondheid = 100;
    }
    
    /**
     * Schiet op een cowboy.
     * @param   tegenstander    De cowboy die beschoten wordt.
     */
    public void schiet(Cowboy tegenstander)
    {
        if(gezondheid > 0)
        {
           tegenstander.geraakt();
        }
    }
   
    /**
     * Vermindert de gezondheidstoestand van de indiaan 
     * met 60 procent. De indiaan verliest een leven indien de 
     * gezondheidstoestand op nul staat en de Indiaan nog 
     * levens heeft.
     */  
    public void geraakt()
    {
        gezondheid = Math.max(0, gezondheid - 60);
        
        if(gezondheid == 0 && aantalLevens > 0)
        {
            aantalLevens--;
            gezondheid = 0;
        }
    }
    
    /**
     * Laat de Indiaan een vredespijp roken met een andere strijder.
     * @param   strijder    De strijder waarmee de vredespijp gerookt wordt.
     */
    public void rookVredesPijp(Cowboy cowboy)
    {
        if(gezondheid !=0 && cowboy != null)
        {
            aantalLevens += 1;
        }
    }
    
    /**
     * Toont de gezondheidsstatus van de indiaan in het terminalvenster.
     */
    public void printInfo()
    {
        System.out.println("Ik ben een Indiaan van het Westen");
        System.out.println("Naam: " + naam);
        System.out.println("Levens: " + aantalLevens);
        System.out.println("Gezondheid: " + gezondheid);
    }
}